### **实验名称**

图像数据处理分析

### **实验目的**

1.  掌握图像数据加载和探索的基本方法。
2.  掌握图像处理的基本方法。
3.  学习图像可视化的方法和工具。
4.  实现以下任务：
    *   数据加载和探索
    *   图像缩放
    *   图像裁剪
    *   图像增强
    *   图像滤镜
    *   结果可视化

### **实验背景**

图像处理是计算机视觉和图像分析的重要组成部分，涉及对数字图像进行各种操作以增强、转换或提取有用的信息。随着数字设备和技术的进步，图像处理在多个领域中得到了广泛应用，如医学图像分析、遥感、视频监控、自动驾驶、娱乐等。

Python Imaging Library（PIL）是 Python 中最早的图像处理库之一，提供了强大的图像处理功能。尽管 PIL 本身不再更新，但其分支项目 Pillow 继续维护和扩展了 PIL 的功能。PIL/Pillow 支持多种图像文件格式，并提供了丰富的图像操作方法，如图像过滤、增强、转换等。

### **实验原理**

本实验旨在通过使用 PIL 库，探索和实现常见的图像处理任务，帮助理解图像处理的基本原理和技术手段。

### **实验环境**

Ubuntu 18.04

Python 3.9

PIL 库

### **建议课时**

2课时

### **实验步骤**

环境准备：

获取数据集

```markup
cd ~
wget http://10.90.3.2/HUP/DataMining/2024/13/lenna.jpg
```

双击打开桌面的“terminal”后，在命令行中输入如下命令，开启 jupyter notebook：

```python
jupyter notebook
```

打开 Jupter，点击右上角上的“New”按钮，选择“python3”创建文件。

![1721522453348.png](./pic/1721522453348.png)

#### 1\. 读取图像并打印基础信息：

```python
from PIL import Image
import matplotlib.pyplot as plt
from IPython.display import display
# 定义图像路径
path = 'lenna.jpg'
im = Image.open(path)

# 1 打印图像信息
# Image 类的属性
print('>>>图像像素大小：', im.size)
print('>>>图像的模式：', im.mode)
print('>>>源文件的文件格式：', im.format)
print('>>>颜色调色板样式：', im.palette)
#显示图片,默认不显示
#display(im)
```

代码运行结果如下:

![image_course_1657_user_45_assignment_20093_1722822847218.png](./pic/image_course_1657_user_45_assignment_20093_1722822847218.png)

可以结合 plt 显示,给图像添加坐标信息,代码如下:

```python
# 2 结合 Plt 显示
plt.figure(num=1, figsize=(8, 5),)
plt.title('使用plt显示图片')
# plt.axis('off') # 不显示坐标轴
plt.imshow(im)
plt.show()
```

代码运行结果如下:

![4.png](./pic/4.png)

#### 2\. 修改图像大小

**缩放图像**

*   im.resize(size, resample)
*   im.thumbnail(size,resample)(创建缩略图) 保留图片的所有部分，只是缩小或者扩大比例而已

resize 方法可以将原始的图像转换大小,size 是转换之后的大小

resample 是重新采样使用的方法，有 Image.BICUBIC，Image.LANCZOS，Image.BILINEAR，Image.NEAREST 四种方法，默认 Image.NEAREST。

*   NEAREST：最近滤波。从输入图像中选取最近的像素作为输出像素。它忽略了所有其他的像素。
*   BILINEAR：双线性滤波。在输入图像的 2x2 矩阵上进行线性插值。注意：PIL 的当前版本，做下采样时该滤波器使用了固定输入模板。
*   BICUBIC：双立方滤波。在输入图像的 4x4 矩阵上进行立方插值。注意：PIL 的当前版本，做下采样时该滤波器使用了固定输入模板。
*   ANTIALIAS：平滑滤波。这是 PIL 1.1.3 版本中新的滤波器。对所有可以影响输出像素的输入像素进行高质量的重采样滤波。

使用 python 进行处理，代码如下：

```python
from PIL import Image

# 设置画布大小
plt.figure(figsize=(10,8))

# original
im = Image.open(path)
print('原图像像素大小：', im.size)
plt.subplot(131);plt.title('original')
plt.imshow(im)

# resize()——>返回新的 image 对象
im_resize = im.resize((100, 100), resample=Image.LANCZOS)
print('im_resize 转换后像素大小：', im_resize.size)
plt.subplot(132);plt.title('im.resize')
plt.imshow(im_resize)

# thumbnail()——>直接覆盖原始的 im
im_thumbnail = im.thumbnail((50, 50), resample=Image.LANCZOS)
print(im_thumbnail)
plt.subplot(133);plt.title('im_thumbnail')
plt.imshow(im)
# plt.axis('off') # 不显示坐标轴
plt.show()
```

代码运行结果如下：

![image_course_1657_user_45_assignment_20093_1722822855733.png](./pic/image_course_1657_user_45_assignment_20093_1722822855733.png)

缩放图像

**裁剪图像**

im.crop(box) 截取图片，图片部分信息丢失

从当前的图像中返回一个矩形区域的拷贝。 变量 box 是一个四元组，定义了左、上、右和下的像素坐标。 请注意：box 中距离设置是以 左上角 x 轴与左上角 y 轴，即（0， 0）为基准来计算的 python 代码如下：

```python
from PIL import Image

im = Image.open(path)
box=(35, 20, 160, 193)  # 注意理解这里的设置
im_crop = im.crop(box)

# 显示
plt.figure(figsize=(7,4))  # 设置画布大小
plt.subplot(121);plt.title('original')
plt.imshow(im)
plt.subplot(122);plt.title('im_crop')
plt.imshow(im_crop)
# plt.axis('off') # 不显示坐标轴
plt.show()
```

代码运行结果如下所示：

![6.png](./pic/6.png)

#### 3\. 图像旋转

图像旋转主要使用 transpose()和 rotate()这两个方法：

```bash
rotate()
    rotate(45) 顺时针 45 度
    rotate(-45) 逆时针 45 度

transpose(method)(图像翻转或者旋转),method 参数如下
    Image.FLIP_LEFT_RIGHT,表示将图像左右翻转
    Image.FLIP_TOP_BOTTOM,表示将图像上下翻转
    Image.ROTATE_90,表示将图像逆时针旋转90°
    Image.ROTATE_180,表示将图像逆时针旋转180°
    Image.ROTATE_270,表示将图像逆时针旋转270°
    Image.TRANSPOSE,表示将图像进行转置(相当于顺时针旋转90°)
    Image.TRANSVERSE,表示将图像进行转置,再水平翻转
```

相关代码如下：

```python
# 设置画布大小
plt.figure(figsize=(10, 5))

im = Image.open(path)
plt.subplot(131);plt.title('original')
plt.imshow(im)

# rotate()
im_rotate = im.rotate(-45) # 顺时针角度表示
plt.subplot(132);plt.title('im_rotate')
plt.imshow(im_rotate)

# transpose()
im_transpose = im.transpose(Image.FLIP_LEFT_RIGHT) # 左右翻转
plt.subplot(133);plt.title('im_transpose')
plt.imshow(im_transpose)
# plt.axis('off') # 不显示坐标轴
plt.show()
```

代码运行结果如下所示：

![7.png](./pic/7.png)

图像旋转和翻转

#### 4\. 图像增强

使用 PIL（Python Imaging Library）中的 Image 和 ImageEnhance 模块来对图像进行各种增强处理，并通过 matplotlib 库显示处理结果。具体过程如下：

```python
from PIL import Image, ImageEnhance
import matplotlib.pyplot as plt
# 设置画布大小
plt.figure(figsize=(10, 8))

# --------------------------------------
# 原始图像
im = Image.open(path)
plt.subplot(231);plt.title('original')
plt.imshow(im)

# ----------图像增强-----------------------
# 增强亮度
# 调整图片的明暗平衡
ie_Brightness = ImageEnhance.Brightness(im)
plt.subplot(232);plt.title('ie_Brightness')
plt.imshow(ie_Brightness.enhance(2.0))
plt.axis('off')  # 关掉坐标轴

# 图片尖锐化
# 锐化/钝化图片
ie_Sharpness = ImageEnhance.Sharpness(im)
plt.subplot(233);plt.title('ie_Sharpness')
plt.imshow(ie_Sharpness.enhance(2.0))

# 对比度增强
# 调整图片的对比度
ie_Contrast = ImageEnhance.Contrast(im)
plt.subplot(234);plt.title('ie_Contrast')
plt.imshow(ie_Contrast.enhance(2.0))

# 色彩增强
# 图片的色彩平衡，相当于彩色电视机的色彩调整
ie_Color = ImageEnhance.Color(im)
plt.subplot(235);plt.title('ie_Color')
plt.imshow(ie_Color.enhance(2.0))
plt.axis('off')  # 关掉坐标轴
plt.show()
```

代码运行结果如下所示：

![8.png](./pic/8.png)

图像增强

#### 5\. 图像滤镜

mageFilter 是 PIL 的滤镜模块，通过这些预定义的滤镜， 可以方便的对图片进行一些过滤操作，从而去掉图片中的噪音(部分的消除)， 这样可以降低将来处理的复杂度(如模式识别等)。

```bash
滤镜名称                              含义
ImageFilter.BLUR                   模糊滤镜
ImageFilter.CONTOUR                  轮廓
ImageFilter.EDGE_ENHANCE           边界加强
ImageFilter.EDGE_ENHANCE_MORE    边界加强(阀值更大)
ImageFilter.EMBOSS                 浮雕滤镜
ImageFilter.FIND_EDGES             边界滤镜
ImageFilter.SMOOTH                 平滑滤镜
ImageFilter.SMOOTH_MORE            平滑滤镜(阀值更大)
ImageFilter.SHARPEN                锐化滤镜
```

示例代码如下所示：

```python
import matplotlib.pyplot as plt
from PIL import Image
from PIL import ImageFilter

# 打开图像
im = Image.open(path)

# 设置滤镜列表和标题
filters = [
    (ImageFilter.BLUR, 'ImageFilter.BLUR'),
    (ImageFilter.CONTOUR, 'ImageFilter.CONTOUR'),
    (ImageFilter.EDGE_ENHANCE, 'ImageFilter.EDGE_ENHANCE'),
    (ImageFilter.EDGE_ENHANCE_MORE, 'ImageFilter.EDGE_ENHANCE_MORE'),
    (ImageFilter.EMBOSS, 'ImageFilter.EMBOSS'),
    (ImageFilter.FIND_EDGES, 'ImageFilter.FIND_EDGES'),
    (ImageFilter.SMOOTH, 'ImageFilter.SMOOTH'),
    (ImageFilter.SMOOTH_MORE, 'ImageFilter.SMOOTH_MORE'),
    (ImageFilter.SHARPEN, 'ImageFilter.SHARPEN')
]

# 设置画布大小
plt.figure(figsize=(18, 8))

# 显示原始图像
plt.subplot(2, 5, 1)
plt.title('original')
plt.imshow(im)

# 遍历滤镜列表并显示处理后的图像
for i, (filter_type, title) in enumerate(filters, start=2):
    im_filtered = im.filter(filter_type)
    plt.subplot(2, 5, i)
    plt.title(title)
    plt.imshow(im_filtered)
    plt.axis('off')  # 关掉坐标轴

# 显示所有处理结果
plt.show()
```

代码运行结果如下所示： ![9.png](./pic/9.png)

图像滤镜

### **实验总结**

通过本实验，期望能够掌握 PIL 库的基本使用方法，理解常见图像处理技术的原理和应用，并能够将这些技术应用于实际的图像处理任务中。同时，通过对比分析不同方法的效果，提升对图像处理技术选择和应用的判断能力。

本实验不仅为深入学习和研究图像处理奠定了基础，还为后续在计算机视觉、图像分析等领域的深入应用提供了有力支持。掌握图像处理的基本技能和方法，对于从事相关领域的研究和开发具有重要意义。